<?php $__env->startSection('content'); ?>
<div class="container">
    <h1 class="mb-4">Products</h1>
    <form method="GET" action="<?php echo e(route('products.index')); ?>" class="mb-4">
    <div class="row g-2">
        <div class="col-md-4">
            <input type="text" name="search" value="<?php echo e(request('search')); ?>"
                   placeholder="Search by Name, Slug or POS ID"
                   class="form-control">
        </div>

        <div class="col-md-3">
            <button type="submit" class="btn btn-primary w-100">
                Search
            </button>
        </div>

        <div class="col-md-3">
            <a href="<?php echo e(route('products.index')); ?>" class="btn btn-secondary w-100">
                Reset
                </a>
        </div>
    </div>
</form>

    <div class="table-responsive shadow-sm rounded">
        <table class="table table-hover align-middle mb-0">
            <thead class="table-dark">
                <tr>
                    <th scope="col">Image</th>
                    <th scope="col">Name</th>
                    <th scope="col">Slug</th>
                    <th scope="col">Category</th>
                    <th scope="col">POS ID</th>
                    <th scope="col">Description</th>
                    <th scope="col" class="text-center">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td class="text-center">
                            <?php if($product->image): ?>
                                <img src="<?php echo e($product->image); ?>" alt="<?php echo e($product->name); ?>"
                                     class="rounded"
                                     style="width: 60px; height: 60px; object-fit: cover;">
                            <?php else: ?>
                                <div style="width: 60px; height: 60px; background: #e9ecef;"
                                     class="d-inline-block rounded"></div>
                            <?php endif; ?>
                        </td>
                        <td><?php echo e($product->name); ?></td>
                        <td><?php echo e($product->slug); ?></td>
                        <td><?php echo e($product->productCategoryName); ?></td>
                        <td><?php echo e($product->posProductId); ?></td>
                        <td><?php echo e(Str::limit($product->description, 50)); ?></td>
                        <td class="text-center">
                            <a href="<?php echo e($product->product_url); ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                <i class="bi bi-box-arrow-up-right"></i> View
                            </a>
                            <a href="<?php echo e(route('products.edit', $product->id)); ?>" class="btn btn-sm btn-outline-warning">
                                <i class="bi bi-pencil-square"></i> Edit
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="7" class="text-center py-4">No products found.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="d-flex justify-content-center mt-4">
        <?php echo e($products->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/darkhorseny/public_html/bk.darkhorse-ny.com/resources/views/products/index.blade.php ENDPATH**/ ?>