

<?php $__env->startSection('title','Events'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Events</h1>
  <a href="<?php echo e(route('events.create')); ?>" class="btn btn-primary">Create Event</a>
</div>

<table class="table table-striped">
  <thead>
    <tr>
      <th>Name</th>
      <th>Start</th>
      <th>End</th>
      <th>Photo</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    <?php $__empty_1 = true; $__currentLoopData = $events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
      <tr>
        <td><?php echo e($event->name); ?></td>
        <td><?php echo e(\Carbon\Carbon::parse($event->start_at)->format('d M Y H:i')); ?></td>
        <td><?php echo e(\Carbon\Carbon::parse($event->end_at)->format('d M Y H:i')); ?></td>
        <td>
          <?php if($event->photo): ?>
            <img src="<?php echo e(asset('storage/'.$event->photo)); ?>" alt="" style="width:80px; height:auto;">
          <?php endif; ?>
        </td>
        <td class="text-end">
           <!-- Publish / Unpublish Button -->
  <form action="<?php echo e(route('events.togglePublish', $event)); ?>" method="POST" class="d-inline">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PATCH'); ?>

      <?php if($event->is_published): ?>
          <button class="btn btn-sm btn-warning">Unpublish</button>
      <?php else: ?>
          <button class="btn btn-sm btn-success">Publish</button>
      <?php endif; ?>
  </form>
          <a href="<?php echo e(route('events.show', $event)); ?>" class="btn btn-sm btn-outline-secondary">Show</a>
          <a href="<?php echo e(route('events.edit', $event)); ?>" class="btn btn-sm btn-outline-primary">Edit</a>

          <form action="<?php echo e(route('events.destroy', $event)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this event?')">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button class="btn btn-sm btn-danger">Delete</button>
          </form>
        </td>
      </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
      <tr>
        <td colspan="5">No events found.</td>
      </tr>
    <?php endif; ?>
  </tbody>
</table>

<?php echo e($events->links()); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/darkhorseny/public_html/bk.darkhorse-ny.com/resources/views/events/index.blade.php ENDPATH**/ ?>