<?php $__env->startSection('content'); ?>
    <h1>All Blog Posts</h1>
    <a href="<?php echo e(route('blogs.create')); ?>" class="btn btn-primary mb-3">Create New Post</a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Image</th>
                <th>Title</th>
                <th>Slug</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                <td>
                        <?php if($blog->image): ?>
                            <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="<?php echo e($blog->image_alt_tag ?? $blog->title); ?>" class="img-fluid" style="max-width: 100px;">
                        <?php endif; ?>
                    </td>
                    <td><a href="<?php echo e(route('blogs.show', $blog->id)); ?>"><?php echo e($blog->title); ?></a></td>
                    <td><?php echo e($blog->slug); ?></td>
                    <!--<td><?php echo e($blog->description); ?></td>-->
                    <td><?php echo e(Str::limit($blog->description, 50)); ?></td>
                    <td>
                    <a href="<?php echo e(route('blogs.show', $blog->id)); ?>" class="btn btn-sm btn-info">View</a>
                        <a href="<?php echo e(route('blogs.edit', $blog->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                        <form action="<?php echo e(route('blogs.destroy', $blog->id)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <tr>
                    <td colspan="3" class="text-center">No blog posts found.</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    
    <?php echo $blogs->links(); ?>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/darkhorseny/public_html/bk.darkhorse-ny.com/resources/views/blogs/index.blade.php ENDPATH**/ ?>