<?php $__env->startSection('content'); ?>
    <div class="container">
        <h1>Edit Product</h1>

        <form action="<?php echo e(route('products.update', $product->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <?php echo method_field('PUT'); ?>

            <div class="mb-3">
                <label>Name</label>
                <input type="text" name="name" value="<?php echo e(old('name', $product->name)); ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Slug</label>
                <input type="text" name="slug" value="<?php echo e(old('slug', $product->slug)); ?>" class="form-control" required>
            </div>

            <div class="mb-3">
                <label>Description</label>
                <textarea name="description" class="form-control"><?php echo e(old('description', $product->description)); ?></textarea>
            </div>

            <div class="mb-3">
                <label>Category</label>
                <input type="text" name="productCategoryName"
                    value="<?php echo e(old('productCategoryName', $product->productCategoryName)); ?>" class="form-control">
            </div>

            <div class="mb-3">
                <label>POS ID</label>
                <input type="text" name="posProductId" value="<?php echo e(old('posProductId', $product->posProductId)); ?>"
                    class="form-control">
            </div>

            <div class="mb-3">
                <label>Image URL</label>
                <input type="text" name="image" value="<?php echo e(old('image', $product->image)); ?>" class="form-control">
            </div>

            <div class="mb-3">
                <label>Meta Title</label>
                <input type="text" name="meta_title" value="<?php echo e(old('meta_title', $product->meta_title)); ?>"
                    class="form-control">
            </div>

            <div class="mb-3">
                <label>Meta Description</label>
                <textarea name="meta_description" class="form-control"><?php echo e(old('meta_description', $product->meta_description)); ?></textarea>
            </div>

            <div class="mb-3">
                <label>Focus Keywords</label>
                <input type="text" name="focus_keywords" value="<?php echo e(old('focus_keywords', $product->focus_keywords)); ?>"
                    class="form-control">
            </div>

            <div class="mb-3">
                <label>Tags</label>
                <input type="text" name="tags" value="<?php echo e(old('tags', $product->tags)); ?>" class="form-control">
            </div>

            <div class="mb-3">
                <label>Schema</label>
                <textarea name="schema" class="form-control" rows="5"><?php echo e(old('schema', $product->schema)); ?></textarea>
            </div>
            <button type="submit" class="btn btn-success">Update Product</button>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/darkhorseny/public_html/bk.darkhorse-ny.com/resources/views/products/edit.blade.php ENDPATH**/ ?>