<?php $__env->startSection('content'); ?>
    <h1>Edit Blog Post</h1>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    
    <form action="<?php echo e(route('blogs.update', $blog->id)); ?>" method="POST" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?> 

        <h3 class="mt-4">SEO Meta Tags</h3>
        <div class="mb-3">
            <label for="meta_title" class="form-label">Meta Title</label>
            <input type="text" name="meta_title" class="form-control" id="meta_title" value="<?php echo e(old('meta_title', $blog->meta_title)); ?>">
        </div>
        <div class="mb-3">
            <label for="meta_description" class="form-label">Meta Description</label>
            <textarea name="meta_description" class="form-control" rows="3"><?php echo e(old('meta_description', $blog->meta_description)); ?></textarea>
        </div>
        <div class="mb-3">
            <label for="meta_url" class="form-label">Meta URL</label>
            <input type="text" name="meta_url" class="form-control" id="meta_url" value="<?php echo e(old('meta_url', $blog->meta_url)); ?>">
        </div>
        <div class="mb-3">
            <label for="image_alt_tag" class="form-label">Image Alt Tag</label>
            <input type="text" name="image_alt_tag" class="form-control" id="image_alt_tag" value="<?php echo e(old('image_alt_tag', $blog->image_alt_tag)); ?>">
        </div>
        
        <div class="mb-3">
            <label for="title" class="form-label">Title</label>
            <input type="text" name="title" class="form-control" id="title" value="<?php echo e(old('title', $blog->title)); ?>">
        </div>

        
        <div class="mb-3">
            <label for="image" class="form-label">Update Feature Image (Optional)</label>
            <input type="file" name="image" class="form-control" id="image">
        </div>

        
        <?php if($blog->image): ?>
            <div class="mb-3">
                <p>Current Image:</p>
                <img src="<?php echo e(asset('storage/' . $blog->image)); ?>" alt="<?php echo e($blog->image_alt_tag ?? 'Current Image'); ?>" style="width: 200px; height: auto;">
            </div>
        <?php endif; ?>

        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <!-- CKEditor will attach here -->
            <textarea name="description" class="form-control" id="description-editor"><?php echo e(old('description', $blog->description)); ?></textarea>
        </div>

       

        <button type="submit" class="btn btn-primary">Update Post</button>
    </form>

    <script>
    ClassicEditor
        .create(document.querySelector('#description-editor'))
        .catch(error => {
            console.error(error);
        });
</script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/darkhorseny/public_html/bk.darkhorse-ny.com/resources/views/blogs/edit.blade.php ENDPATH**/ ?>