<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\DispenseController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\BlogApiController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\ContactController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return view('auth.login');
});

Route::resource('blogs', BlogController::class);

Route::get('/dashboard', function () {
    return view('dashboard');
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // Products CRUD
    Route::resource('products', ProductController::class);

    // // Dispense products route (protected)
    // Route::get('/dispense/fetch-save', [DispenseController::class, 'getData']);
    // Route::get('/dispense/products', [DispenseController::class, 'showProducts']);
   
    
});

 // Dispense products route (protected)
    Route::get('/dispense/fetch-save', [DispenseController::class, 'getData']);
    Route::get('/dispense/products', [DispenseController::class, 'showProducts']);

Route::get('/my-products', [ProductController::class, 'apiProducts']);
Route::get('product-details', [ProductController::class, 'apiProductDetails']);
Route::get('/blog-api', [BlogApiController::class, 'apiIndex']);      // Saare blogs ke liye
Route::get('/blog-api/{id}', [BlogApiController::class, 'apiShow']); // Ek blog ke liye
Route::get('/blog/{slug}', [BlogApiController::class, 'apiShowBySlug']); // Slug ke base pe
// 1️⃣ Event CRUD (Resource Routes)
Route::resource('events', EventController::class);
// 2️⃣ Event API (web ke andar hi, but different URL)
// publish/unpublish route

Route::patch('events/{event}/toggle-publish', [EventController::class, 'togglePublish'])->name('events.togglePublish');
Route::get('events/list/api', [EventController::class, 'apiIndex'])
     ->name('events.api');
     

Route::get('/contacts', [ContactController::class, 'index'])->name('contacts.index');
require __DIR__.'/auth.php';