@extends('layouts.app')

@section('title','Event Details')

@section('content')
<h1>{{ $event->name }}</h1>

<p><strong>Start:</strong> {{ \Carbon\Carbon::parse($event->start_at)->format('d M Y H:i') }}</p>
<p><strong>End:</strong> {{ \Carbon\Carbon::parse($event->end_at)->format('d M Y H:i') }}</p>

@if($event->photo)
  <div class="mb-3">
    <img src="{{ asset('storage/'.$event->photo) }}" alt="" style="max-width:400px;">
  </div>
@endif

<p>{!! nl2br(e($event->description)) !!}</p>

<a href="{{ route('events.edit', $event) }}" class="btn btn-primary">Edit</a>
<a href="{{ route('events.index') }}" class="btn btn-secondary">Back</a>
@endsection