@extends('layouts.app')

@section('title','Events')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-3">
  <h1>Events</h1>
  <a href="{{ route('events.create') }}" class="btn btn-primary">Create Event</a>
</div>

<table class="table table-striped">
  <thead>
    <tr>
      <th>Name</th>
      <th>Start</th>
      <th>End</th>
      <th>Photo</th>
      <th></th>
    </tr>
  </thead>
  <tbody>
    @forelse($events as $event)
      <tr>
        <td>{{ $event->name }}</td>
        <td>{{ \Carbon\Carbon::parse($event->start_at)->format('d M Y H:i') }}</td>
        <td>{{ \Carbon\Carbon::parse($event->end_at)->format('d M Y H:i') }}</td>
        <td>
          @if($event->photo)
            <img src="{{ asset('storage/'.$event->photo) }}" alt="" style="width:80px; height:auto;">
          @endif
        </td>
        <td class="text-end">
           <!-- Publish / Unpublish Button -->
  <form action="{{ route('events.togglePublish', $event) }}" method="POST" class="d-inline">
      @csrf
      @method('PATCH')

      @if($event->is_published)
          <button class="btn btn-sm btn-warning">Unpublish</button>
      @else
          <button class="btn btn-sm btn-success">Publish</button>
      @endif
  </form>
          <a href="{{ route('events.show', $event) }}" class="btn btn-sm btn-outline-secondary">Show</a>
          <a href="{{ route('events.edit', $event) }}" class="btn btn-sm btn-outline-primary">Edit</a>

          <form action="{{ route('events.destroy', $event) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this event?')">
            @csrf
            @method('DELETE')
            <button class="btn btn-sm btn-danger">Delete</button>
          </form>
        </td>
      </tr>
    @empty
      <tr>
        <td colspan="5">No events found.</td>
      </tr>
    @endforelse
  </tbody>
</table>

{{ $events->links() }}
@endsection