@extends('layouts.app')

@section('title','Edit Event')

@section('content')
<h1>Edit Event</h1>

<form action="{{ route('events.update', $event) }}" method="POST" enctype="multipart/form-data">
  @csrf
  @method('PUT')

  <div class="mb-3">
    <label class="form-label">Name</label>
    <input type="text" name="name" class="form-control" value="{{ old('name', $event->name) }}">
    @error('name') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Starting Date & Time</label>
    <input type="datetime-local" name="start_at" class="form-control" value="{{ old('start_at', \Carbon\Carbon::parse($event->start_at)->format('Y-m-d\TH:i')) }}">
    @error('start_at') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Ending Date & Time</label>
    <input type="datetime-local" name="end_at" class="form-control" value="{{ old('end_at', \Carbon\Carbon::parse($event->end_at)->format('Y-m-d\TH:i')) }}">
    @error('end_at') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Photo</label>
    @if($event->photo)
      <div class="mb-2">
        <img src="{{ asset('storage/'.$event->photo) }}" alt="" style="width:150px;">
      </div>
    @endif
    <input type="file" name="photo" class="form-control">
    @error('photo') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control" rows="4">{{ old('description', $event->description) }}</textarea>
    @error('description') <div class="text-danger">{{ $message }}</div> @enderror
  </div>
  
<div class="mb-3">
    <label>
        <input type="checkbox" name="is_published" value="1"
            {{ old('is_published', $event->is_published ?? true) ? 'checked' : '' }}>
        Publish this event
    </label>
</div>
  <button class="btn btn-primary">Update</button>
  <a href="{{ route('events.index') }}" class="btn btn-secondary">Cancel</a>
</form>
@endsection