@extends('layouts.app')

@section('title','Create Event')

@section('content')
<h1>Create Event</h1>

<form action="{{ route('events.store') }}" method="POST" enctype="multipart/form-data">
  @csrf

  <div class="mb-3">
    <label class="form-label">Name</label>
    <input type="text" name="name" class="form-control" value="{{ old('name') }}">
    @error('name') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Starting Date & Time</label>
    <input type="datetime-local" name="start_at" class="form-control" value="{{ old('start_at') }}">
    @error('start_at') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Ending Date & Time</label>
    <input type="datetime-local" name="end_at" class="form-control" value="{{ old('end_at') }}">
    @error('end_at') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Photo</label>
    <input type="file" name="photo" class="form-control">
    @error('photo') <div class="text-danger">{{ $message }}</div> @enderror
  </div>

  <div class="mb-3">
    <label class="form-label">Description</label>
    <textarea name="description" class="form-control" rows="4">{{ old('description') }}</textarea>
    @error('description') <div class="text-danger">{{ $message }}</div> @enderror
  </div>
  
<div class="mb-3">
    <label>
        <input type="checkbox" name="is_published" value="1"
            {{ old('is_published', $event->is_published ?? true) ? 'checked' : '' }}>
        Publish this event
    </label>
</div>
  <button class="btn btn-success">Save</button>
  <a href="{{ route('events.index') }}" class="btn btn-secondary">Cancel</a>
</form>
@endsection