@extends('layouts.app')

@section('content')
    <a href="{{ route('blogs.index') }}" class="btn btn-secondary mb-4">< Back to all posts</a>
    
    <h1>{{ $blog->title }}</h1>
    <p class="text-muted">Created on {{ $blog->created_at->format('M d, Y') }}</p>

    {{-- Yahan image dikhayenge --}}
    @if($blog->image)
        <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->image_alt_tag ?? $blog->title }}" class="img-fluid my-4">
    @endif

    <div class="blog-content mt-4">
        {{-- IMPORTANT: Use {!! !!} to render the HTML from CKEditor --}}
        {!! $blog->description !!}
    </div>

    <hr>
    <h3>Meta Information</h3>
    <ul>
        <li><strong>Meta Title:</strong> {{ $blog->meta_title ?? 'N/A' }}</li>
        <li><strong>Meta Description:</strong> {{ $blog->meta_description ?? 'N/A' }}</li>
        <li><strong>Meta URL:</strong> {{ $blog->meta_url ?? 'N/A' }}</li>
    </ul>
@endsection