@extends('layouts.app')

@section('content')
    <h1>All Blog Posts</h1>
    <a href="{{ route('blogs.create') }}" class="btn btn-primary mb-3">Create New Post</a>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Image</th>
                <th>Title</th>
                <th>Slug</th>
                <th>Description</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($blogs as $blog)
                <tr>
                <td>
                        @if($blog->image)
                            <img src="{{ asset('storage/' . $blog->image) }}" alt="{{ $blog->image_alt_tag ?? $blog->title }}" class="img-fluid" style="max-width: 100px;">
                        @endif
                    </td>
                    <td><a href="{{ route('blogs.show', $blog->id) }}">{{ $blog->title }}</a></td>
                    <td>{{ $blog->slug }}</td>
                    <!--<td>{{ $blog->description }}</td>-->
                    <td>{{ Str::limit($blog->description, 50) }}</td>
                    <td>
                    <a href="{{ route('blogs.show', $blog->id) }}" class="btn btn-sm btn-info">View</a>
                        <a href="{{ route('blogs.edit', $blog->id) }}" class="btn btn-sm btn-warning">Edit</a>
                        <form action="{{ route('blogs.destroy', $blog->id) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="3" class="text-center">No blog posts found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    {{-- For pagination links --}}
    {!! $blogs->links() !!}
@endsection