@extends('layouts.app')

@section('content')
    <h1>Create New Blog Post</h1>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- BADLAV 1: Form mein enctype add karna zaroori hai --}}
    <form action="{{ route('blogs.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <h3 class="mt-4">SEO Meta Tags</h3>
        <div class="mb-3">
            <label for="meta_title" class="form-label">Meta Title</label>
            <input type="text" name="meta_title" class="form-control" id="meta_title" value="{{ old('meta_title') }}">
        </div>
        <div class="mb-3">
            <label for="meta_description" class="form-label">Meta Description</label>
            <textarea name="meta_description" class="form-control" rows="3">{{ old('meta_description') }}</textarea>
        </div>
        <div class="mb-3">
            <label for="meta_url" class="form-label">Meta URL</label>
            <input type="text" name="meta_url" class="form-control" id="meta_url" value="{{ old('meta_url') }}">
        </div>
        <div class="mb-3">
            <label for="image_alt_tag" class="form-label">Image Alt Tag</label>
            <input type="text" name="image_alt_tag" class="form-control" id="image_alt_tag" value="{{ old('image_alt_tag') }}">
        </div>
        
        <div class="mb-3">
            <label for="title" class="form-label">Title</label>
            <input type="text" name="title" class="form-control" id="title" value="{{ old('title') }}">
        </div>

        {{-- BADLAV 2: Image upload ke liye file input --}}
        <div class="mb-3">
            <label for="image" class="form-label">Feature Image</label>
            <input type="file" name="image" class="form-control" id="image">
        </div>

        <div class="mb-3">
            <label for="description" class="form-label">Description</label>
            <textarea name="description" class="form-control" id="description-editor">{{ old('description') }}</textarea>
        </div>

        <button type="submit" class="btn btn-primary">Create Post</button>
    </form>

    <script>
    ClassicEditor
        .create(document.querySelector('#description-editor'))
        .catch(error => {
            console.error(error);
        });
</script>
@endsection

