<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id(); // Auto-incrementing BigInt Primary Key: `id`

            // Main Blog Content
            $table->string('title'); // The main title of the blog post 
            $table->string('slug')->unique(); // URL-friendly version of the title, must be unique 
            $table->longText('description'); // The main content/body of the blog post 
            $table->string('image')->nullable(); // Path to the main blog image, nullable if a post has no image

            // SEO & Meta Tag Columns
            $table->string('meta_title')->nullable(); // SEO Title for search engines
            $table->longText('meta_description')->nullable(); // SEO Description for search engines
            $table->string('meta_url')->nullable(); // Canonical URL or a specific meta URL
            $table->string('image_alt_tag')->nullable(); // Alt text for the main image for accessibility and SEO

            // Timestamps
            $table->timestamps(); // Creates `created_at` and `updated_at` columns
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
