<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Event extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'start_at',
        'end_at',
        'photo',
        'description',
        'is_published',
    ];

    // Accessor for full URL of photo (optional)
    public function getPhotoUrlAttribute()
    {
        if (!$this->photo) return null;
        return asset('storage/' . $this->photo);
    }
}