<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Product;

class ProductController extends Controller
{
      public function index(Request $request)
{
    $query = Product::query();

    if ($request->filled('search')) {
        $search = $request->search;

        $query->where('name', 'like', "%$search%")
              ->orWhere('slug', 'like', "%$search%")
              ->orWhere('posProductId', 'like', "%$search%");
    }

    $products = $query->latest()->paginate(20);

    return view('products.index', compact('products'));
}
    public function edit(Product $product)
    {
        return view('products.edit', compact('product'));
    }

    public function update(Request $request, Product $product)
    {
        $request->validate([
            'name' => 'required',
            'slug' => 'required',
            'description' => 'nullable',
            'productCategoryName' => 'nullable',
            'posProductId' => 'nullable',
            'image' => 'nullable|url',
            'meta_title' => 'nullable',
            'meta_description' => 'nullable',
            'focus_keywords' => 'nullable',
            'tags' => 'nullable',
            'schema' => 'nullable',
        ]);

        $product->update($request->all());

        return redirect()->route('products.index')
                        ->with('success', 'Product updated successfully.');
    }


    public function destroy(Product $product)
    {
        $product->delete();
        return redirect()->route('products.index')
                         ->with('success', 'Product deleted successfully.');
    }

    public function apiProducts()
    {
        // dd('kdkdskjdsjk');
        return response()->json([
            'success' => true,
            'data' => Product::get()
        ]);
    }
    public function apiProductDetails(Request $request)
    {
        $product = Product::where('uuid', $request->id)->first();
        return response()->json([
            'success' => true,
            'data' => $product
        ]);
    }
}
