<?php

namespace App\Http\Controllers;

use App\Models\Contact;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use App\Mail\ContactReceived;

class ContactController extends Controller
{
    /**
     * Store contact (POST API).
     */
    public function submit(Request $request)
    {
        // Validate input
        $data = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255',
            'message' => 'required|string',
        ]);

        // Save to DB
        $contact = Contact::create($data);

        // Send email to admin (synchronous)
        try {
            Mail::to('satyam.webroottech@gmail.com')->send(new ContactReceived($contact));
        } catch (\Exception $e) {
            // If email fails, optionally log and continue
            \Log::error('Contact email send failed: '.$e->getMessage());
            // You may return error if you want to fail the request instead.
        }

        // Return JSON response (since frontend not required)
        return response()->json([
            'success' => true,
            'message' => 'Contact saved and email sent (if mail configured).',
            'data' => $contact,
        ], 201);
    }

    public function index()
{
    // Paginate for frontend table
    $contacts = Contact::latest()->paginate(20);

    // return view with data
    return view('contacts.index', compact('contacts'));
}
}