<?php

namespace App\Http\Controllers;

use App\Models\Blog; // <<-- YEH LINE SABSE ZAROORI HAI, 
use Illuminate\Http\Request;

class BlogApiController extends Controller
{
    /**
     * API endpoint to get a list of all blog posts.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function apiIndex()
    {
        // Ab yeh line kaam karegi kyunki controller ko pata hai 'Blog' kya hai
        $blogs = Blog::latest()->paginate(15);

        return response()->json([
            'success' => true,
            'data' => $blogs
        ]);
    }

    /**
     * API endpoint to get a single blog post by ID.
     *
     * @param  int  $id
     * @return \Illuminate\Http\JsonResponse
     */
    public function apiShow($id)
    {
        // Ab yeh line bhi kaam karegi
        $blog = Blog::find($id);

        if (!$blog) {
            return response()->json([
                'success' => false,
                'message' => 'Blog not found.'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $blog
        ]);
    }

    public function apiShowBySlug($slug)
    {
        // Ab yeh line bhi kaam karegi
        $blog = Blog::where('slug', $slug)->first();

        if (!$blog) {
            return response()->json([
                'success' => false,
                'message' => 'Blog not found.'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $blog
        ]);
    }
}


